# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand
from intranet.yandex_directory.src.yandex_directory.common.commands.base import Option
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_meta_connection,
    get_shard_numbers,
)
from intranet.yandex_directory.src.yandex_directory.core.models import (
    ExcludedShardModel,
)


class Command(BaseCommand):
    name = 'excluded-shards'
    option_list = (
        Option('--list', '-l', dest='shard_list', action='store_true', help='List of excluded shards'),
        Option('--add', '-a',  dest='add', type=int, help='Add shard to excluded'),
        Option('--delete', '-d', dest='delete', type=int, help='Delete shard from excluded'),
    )

    def run(self, shard_list=None, add=None, delete=None):
        with get_meta_connection(for_write=True) as meta:
            if not any([shard_list, add, delete]):
                print('Pass at least one parameter: list, add or delete')
            if add:
                shards = get_shard_numbers()
                if add not in shards:
                    print('Shard {} doesn\'t exist'.format(add))
                    return
                excluded_shards = ExcludedShardModel(meta).fields('shard').scalar()
                if add in excluded_shards:
                    print('Shard {} already excluded'.format(add))
                elif set(shards) - set(excluded_shards) == set([add]):
                    print('You can not delete the last available shard')
                else:
                    ExcludedShardModel(meta).create(add)
            if delete:
                ExcludedShardModel(meta).delete_one(delete)
            if shard_list:
                excluded_shards = ExcludedShardModel(meta).fields('shard').scalar()
                print('Excluded shards: {}'.format(excluded_shards))
