# -*- coding: utf-8 -*-
import random
import uuid

from intranet.yandex_directory.src.yandex_directory.core.mailer import send
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option
from intranet.yandex_directory.src.yandex_directory.common.db import get_main_connection


class Command(BaseCommand):
    """
    Генерируем письма для тестирования мигратора.
    Отправляем письма через рассылятор для наполнения письмами.
    """
    name = 'fill-fake-email'
    option_list = (
        Option(
            '--campaign-slug',
            '-c',
            dest='campaign_slug',
            type=str,
            required=False,
            default='W2DHW9S2-6FX1',  # https://sender.yandex-team.ru/ya.connect/campaign/20183/overview
            help='Sender campaign',
        ),
        Option(
            '--emails-file',
            '-e',
            dest='emails_file',
            type=str,
            required=True,
            help='File with target mails',
        ),
        Option(
            '--min-count',
            '-f',
            dest='min_count',
            type=int,
            required=False,
            default=0,
            help='Min email count',
        ),
        Option(
            '--max-count',
            '-t',
            dest='max_count',
            type=int,
            required=False,
            default=10,
            help='Max email count',
        ),
    )

    def run(self, campaign_slug, emails_file, min_count, max_count):
        with get_main_connection(1, for_write=True) as main_connection:
            with open(emails_file, 'r') as f:
                for email in f:
                    mails_count = random.randint(min_count, max_count)
                    for _ in range(mails_count):
                        send(
                            main_connection=main_connection,
                            campaign_slug=campaign_slug,
                            org_id=-1,  # тут организация не нужна
                            to_email=email.strip(),
                            mail_args={'uuid': str(uuid.uuid4())}
                        )
