# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option
from intranet.yandex_directory.src.yandex_directory.common.db import get_meta_connection
from intranet.yandex_directory.src.yandex_directory.core.models.user import get_external_org_ids


def ensure_uid(uid_or_login):
    """Возвращает uid или None, если такой логин не существует в паспорте."""
    try:
        return int(uid_or_login)
    except ValueError:
        # Если строка не похожа на число, то попробуем из blackbox
        # определить есть ли такой аккаунт
        return app.blackbox_instance.uid(uid_or_login)


def get_external_org_ids_from_blackbox(uid):
    info = app.blackbox_instance.userinfo(uid=uid, userip='127.0.0.1', attributes='1017')
    attributes = info['attributes']
    org_ids = attributes.get('1017', '')
    org_ids = org_ids.split(',')
    org_ids = list(map(int, [_f for _f in org_ids if _f]))
    return org_ids


def org_ids_to_string(org_ids):
    if org_ids:
        return ', '.join(map(str, org_ids))
    else:
        return 'no org ids'


class Command(BaseCommand):
    """Команда для проверки списка org_id привязанных в blackbox к пользователю.

       На вход может принимать, как uid, так и логин. Если логин задан без домена,
       то предполагается, что он портальный - some@yandex.ru
    
       https://st.yandex-team.ru/DIR-6080
    """
    name = 'get-external-org-ids'
    option_list = (
        Option('uids_or_logins', nargs='+'),
    )

    def run(self, uids_or_logins): #*args, **kwargs):
        with get_meta_connection() as meta_connection:
            for uid_or_login in uids_or_logins:
                uid = ensure_uid(uid_or_login)
                if uid:
                    org_ids_from_dir = sorted(get_external_org_ids(meta_connection, uid))
                    org_ids_from_blackbox = sorted(get_external_org_ids_from_blackbox(uid))

                    if org_ids_from_dir == org_ids_from_blackbox:
                        print('{0}\n  have same org_ids in blackbox and directory: {1}'.format(
                            uid_or_login,
                            org_ids_to_string(org_ids_from_dir),
                        ))
                    else:
                        print('{0}\n  have difference - in directory: {1}, in blackbox: {2}'.format(
                            uid_or_login,
                            org_ids_to_string(org_ids_from_dir),
                            org_ids_to_string(org_ids_from_blackbox),
                        ))
                else:
                    print('{0}\n  not found in blackbox'.format(uid_or_login))
