# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.commands.base import TransactionalCommand, Option
from intranet.yandex_directory.src.yandex_directory.common.json import dumps
from intranet.yandex_directory.src.yandex_directory.core.importer.exception import ImporterDataError
from intranet.yandex_directory.src.yandex_directory.core.importer.from_json import (
    JsonImporter
)


class Command(TransactionalCommand):
    """
    Импорт в организацию пользоватлей и отделов из json файла
    """
    name = 'import-data-from-json'

    option_list = (
        Option('--org-id', '-o', dest='org_id', type=int, required=True, help='Organization id.'),
        Option('--input-file-path', '-i', dest='file_path', required=True, help='Import json file.'),
        Option('--output-file-path', '-r', dest='output_file_path', required=True, help='Result file name.'),
    )

    def run(self, shard, org_id, file_path, output_file_path):
        with open(file_path) as json_file:
            try:
                importer = JsonImporter(
                    meta_connection=self.meta_connection,
                    main_connection=self.main_connection,
                    org_id=org_id,
                )
                importer.load(json_file)
                result = importer.start_import()
                with open(output_file_path, 'w') as out_json_file:
                    out_json_file.write(dumps(result))
                self.log.info('ImportDataFromJsonCommand end')
            except ImporterDataError as e:
                print(e.__class__.__name__, ':', e)
                self.log.exception('Import data error')
