# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand, Option
from intranet.yandex_directory.src.yandex_directory.core.models import (
    DepartmentModel,
    OrganizationModel,
)


def _run_on_organization(main_connection, org_id):
    dep_model = DepartmentModel(main_connection)
    dep_model.update(
        filter_data={
            'org_id': org_id
        },
        update_data={
            'members_count': 0
        }
    )
    department_ids = [d['id'] for d in dep_model.find({'org_id': org_id})]

    for department_id in department_ids:
        with log.fields(dep_id=department_id):
            dm = DepartmentModel(main_connection)
            dm.update_members_count(
                department_id,
                org_id,
            )
            log.debug('Updated members count')


class Command(AllShardsCommand):
    """
    Заполняем значение поля "departments.members_count"
    В нем кэшируется общее количество сотрудников в отделе и подотделах

    Смотри миграцию `V0020__add_sub_members_count_departments_attr.sql`
    """
    name = 'init-members-count'
    option_list = (
        Option('--org-id', '-o', dest='org_id', required=False, type=int),
    )

    def run(self, org_id=None):
        organizations = OrganizationModel(self.main_connection).find()
        for organization in organizations:
            if org_id is None or org_id == organization['id']:
                with log.fields(org_id=organization['id']), self.main_connection.begin_nested():
                    _run_on_organization(self.main_connection, organization['id'])
