# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand
from intranet.yandex_directory.src.yandex_directory.core.models import (
    OrganizationModel,
    UserModel,
)

import logging
from tqdm import tqdm


class Command(AllShardsCommand):
    """
    Миграция данных, для того, чтобы для каждой организации был
    в базе прописан соответсвующий uid админа (пока только внутреннего админа).
    """
    name = 'migrate-exists-orgadmins'

    def run(self):
        organizations = OrganizationModel(self.main_connection).find()
        for organization in tqdm(organizations):
            exist_admins = UserModel(
                self.main_connection
            ).get_organization_admins(org_id=organization['id'])

            if not exist_admins:
                logging.info("Organization %s have not admin_group "
                             "with admins" % organization['id'])
                continue
            with self.main_connection.begin_nested():
                OrganizationModel(self.main_connection).update(
                    update_data=dict(admin_uid=exist_admins[0]['id']),
                    filter_data={
                        'id': organization['id']
                    }
                )
                logging.info("Set admin_uid=%s to organization (%s; %s)\n" % (
                    organization.get("admin_uid"),
                    organization["label"],
                    organization["id"],
                ))
