# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand

from intranet.yandex_directory.src.yandex_directory.core.models.group import (
    GroupModel,
    UserGroupMembership,
)


class Command(AllShardsCommand):
    """
    Миграция кол-во участников в группе
    """
    name = 'migrate-group-members-count'

    def run(self):
        groups = GroupModel(self.main_connection).find()
        for group in groups:
            filter_data = {
                'org_id': group['org_id'],
                'group_id': group['id'],
            }
            members_count = UserGroupMembership(self.main_connection).count(
                filter_data=filter_data
            )
            with self.main_connection.begin_nested():
                GroupModel(self.main_connection).update(
                    update_data={
                        'members_count': members_count,
                    },
                    filter_data={
                        'id': group['id'],
                        'org_id': group['org_id'],
                    }
                )
