# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand
from intranet.yandex_directory.src.yandex_directory.core.utils import only_fields
from intranet.yandex_directory.src.yandex_directory.core.models import (
    UserModel,
    UserDismissedModel,
)


class Command(AllShardsCommand):
    """Одноразовая команда, нужна для того, чтобы устранить аномалии
    в базе. Подробности в тикете DIR-2312.
    """
    name = 'normalize-dismissed'

    def run(self, *args, **kwargs):
        m_user = UserModel(self.main_connection)
        m_user_dismissed = UserDismissedModel(self.main_connection)

        # пройдём по всем записям про уволенных пользователей
        for dismissed in m_user_dismissed.find():
            # и если на самом деле он не уволен
            if m_user.count(
                    {
                        'org_id': dismissed['org_id'],
                        'id': dismissed['user_id'],
                        'is_dismissed': False,
                    }
            ) > 0:
                filter_data = only_fields(dismissed, 'org_id', 'user_id')
                with log.fields(**filter_data):
                    # то удалим запись про уволенность
                    m_user_dismissed.delete(filter_data)
