# -*- coding: utf-8 -*-
import datetime

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory.common.commands.base import (
    AllShardsCommand,
    Option,
)
from intranet.yandex_directory.src.yandex_directory.common.utils import utcnow
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.core.models.service import OrganizationServiceModel
from intranet.yandex_directory.src.yandex_directory.core.utils import only_attrs


class Command(AllShardsCommand):
    name = 'notify-about-trial-expiration'
    option_list = (
        Option('--org-id', '-o', dest='org_id', type=int, required=False, help='Organization id'),
    )

    def run(self, org_id):
        # получаем все возможные дни для отправки
        mail_days = set()
        for _, service_config in app.config['MAIL_IDS_BEFORE_TRIAL_END'].items():
            mail_days.update(set(service_config.keys()))

        today = utcnow()
        mail_days = [
            (today + datetime.timedelta(days=day)).date() for day in mail_days
        ]

        # и выберем сервисы у которых триал истекает в какую-то из этих дат
        filter_data = {
            'trial_expires': mail_days,
        }

        if org_id:
            filter_data['org_id'] = org_id

        org_ids = only_attrs(
            OrganizationServiceModel(self.main_connection).find(
                fields=['org_id'],
                filter_data=filter_data,
                distinct=True,
            ),
            'org_id',
        )

        for org_id in org_ids:
            try:
                with self.main_connection.begin_nested():
                    OrganizationServiceModel(self.main_connection).send_mail_about_trial_expiration_if_needed(org_id=org_id)
            except:
                log.trace().error('Unable to send mail about trial expiration')
