from collections import defaultdict

from intranet.yandex_directory.src.yandex_directory.core.models import (
    OrganizationMetaModel, OrganizationModel, OrganizationServiceModel, UserServiceLicenses,
    OrganizationLicenseConsumedInfoModel
)
from intranet.yandex_directory.src.yandex_directory.common.utils import Ignore
from intranet.yandex_directory.src.yandex_directory.common.db import get_meta_connection, get_main_connection
from intranet.yandex_directory.src.yandex_directory.core.models import UserModel

contact_fields = ('org_id', 'id', 'position', 'position_plain', 'first_name', 'last_name', 'middle_name', 'email',)


def format_person(person, role):
    if person['middle_name']:
        fio = f"{person['last_name']} {person['first_name']} {person['middle_name']}"
    else:
        fio = f"{person['last_name']} {person['first_name']}"
    subrow = [
        fio,
        role,
        person['position_plain'] if person['position_plain'] else '-',
        person['email'],
    ]
    return subrow


def export_uids_by_org_id(org_ids):
    tracker_id = 3
    shard_to_org_ids = defaultdict(list)

    with get_meta_connection() as meta_connection:
        metas = OrganizationMetaModel(meta_connection).filter(id=org_ids).fields('id', 'shard')
        for meta in metas:
            shard = meta['shard']
            org_id = meta['id']
            shard_to_org_ids[shard].append(org_id)

    org_info = {}

    for shard, shard_org_ids in shard_to_org_ids.items():
        with get_main_connection(shard=shard) as main_connection:
            shard_orgs = OrganizationModel(main_connection).filter(id__in=shard_org_ids).fields(
                'id', 'name', 'organization_type', 'admin_uid', 'name', 'user_count',
            )
            org_services = OrganizationServiceModel(main_connection).filter(
                service_id=tracker_id, org_id__in=shard_org_ids, enabled=Ignore,
            ).fields(
                'org_id', 'enabled', 'enabled_at', 'disabled_at', 'disable_reason',
            )
            id_to_org_service = {}
            for item in org_services:
                id_to_org_service[item['org_id']] = item

            for item in shard_orgs:
                org_id = item['id']
                license_count = UserServiceLicenses(main_connection).filter(org_id=org_id).count()
                owner = UserModel(main_connection).filter(id=item['admin_uid'], is_dismissed=False).fields(*contact_fields).one()
                admins = OrganizationModel(main_connection).get_admins(org_id)
                if not id_to_org_service[org_id]['enabled']:
                    last_consumed_date = (OrganizationLicenseConsumedInfoModel(main_connection).filter(org_id=org_id, service_id=tracker_id).order_by('-for_date').limit(1).one())
                    if last_consumed_date:
                        for_date = last_consumed_date['for_date']
                        license_count_by_activity = OrganizationLicenseConsumedInfoModel(main_connection).filter(
                            org_id=org_id,
                            service_id=tracker_id,
                            for_date=for_date
                        ).count()
                        # if license_count != license_count_by_activity:
                        #     print(org_id, license_count, license_count_by_activity)

                org_info[org_id] = {
                    'org_id': org_id,
                    'org_name': item['name'],
                    'org_type': item['organization_type'],
                    'users_count': item['user_count'],
                    'is_big': item['user_count'] >= 100,
                    'tracker_status': id_to_org_service[org_id]['enabled'],
                    'enabled_at': id_to_org_service[org_id]['enabled_at'],
                    'disabled_at': id_to_org_service[org_id]['disabled_at'],
                    'disabled_reason': id_to_org_service[org_id]['disable_reason'],
                    'license_count': license_count,
                    'owner': owner,
                    'admins': admins,
                }

    header = [
        'org_id',
        'org_name',
        'org_type',
        'users_count',
        'is_100_plus',
        'tracker_status',
        'license_count',
        'disabled_reason',
        'enabled_at',
        'disabled_at',
    ]

    contact_block = [
        'contact_fio',
        'contact_role',
        'contact_position',
        'contact_email',
    ]
    #print(';'.join(header))

    rows = []
    max_admin_count = 0
    for org_id in org_ids:
        info = org_info[org_id]
        result_row = [
            str(info['org_id']),
            info['org_name'],
            info['org_type'],
            str(info['users_count']),
            'да' if info['is_big'] else 'нет',
            'да' if info['tracker_status'] else 'нет',
            str(info['license_count']),
            str(info['disabled_reason']),
            info['enabled_at'].strftime('%d.%m.%Y') if info['enabled_at'] else '',
            info['disabled_at'].strftime('%d.%m.%Y') if info['disabled_at'] else '',
        ]

        if info['owner']:
            result_row.extend(format_person(info['owner'], 'owner'))

        max_admin_count = max(max_admin_count, len(info['admins']))
        for admin in info['admins']:
            if info['owner'] and admin['id'] != info['owner']['id']:
                result_row.extend(format_person(admin, 'admin'))
        rows.append(result_row)

    header.extend(contact_block * (max_admin_count + 1))
    print('\ufeff')  # bom
    print(';'.join(header))
    for row in rows:
        print(';'.join(row))



org_ids = [
238,
278,
334,
774,
778,
783,
914,
1022,
1062,
1114,
1129,
1199,
1219,
1263,
1357,
1435,
1474,
1489,
1627,
1692,
1810,
1826,
2066,
2080,
2369,
2394,
2403,
2406,
2408,
2456,
2628,
2931,
3046,
3378,
3416,
3766,
4061,
4133,
4261,
4297,
4327,
5507,
6062,
6194,
6348,
6599,
7465,
7851,
8587,
8623,
8626,
8848,
9192,
9250,
9698,
9913,
9970,
9997,
9998,
10155,
10769,
10830,
11126,
11262,
11341,
11392,
11427,
11467,
11492,
11520,
11698,
11805,
12070,
12154,
12607,
12611,
12623,
12645,
12681,
12976,
12982,
13248,
13284,
13291,
13325,
13407,
13555,
13657,
13692,
13699,
13717,
13806,
13908,
13909,
13939,
13947,
13971,
14039,
14046,
14158,
14328,
14417,
14585,
14594,
14742,
14813,
14957,
15157,
15252,
15356,
15377,
15681,
15803,
15885,
16100,
16144,
16174,
16345,
16387,
17179,
21030,
21060,
21121,
21383,
21642,
21664,
21772,
22523,
22584,
22585,
22635,
22694,
22730,
23266,
23364,
23609,
23687,
23689,
23718,
23927,
24254,
24568,
24693,
24887,
24918,
25381,
25397,
25419,
25435,
25469,
25551,
25566,
25595,
25661,
25697,
25701,
25825,
25968,
26028,
26044,
26204,
26396,
26492,
26961,
27041,
27467,
27527,
27843,
28254,
28324,
28550,
28790,
28847,
28955,
29016,
29094,
29108,
29144,
29374,
29524,
29698,
29883,
29904,
30007,
30059,
30100,
30141,
30508,
30578,
30739,
30898,
30982,
31007,
31016,
31203,
31204,
31483,
31677,
32053,
33547,
33568,
34009,
34112,
34381,
34554,
34723,
34896,
34898,
35055,
35081,
35089,
35097,
35103,
35159,
35249,
35333,
35456,
35547,
35597,
35637,
35709,
35920,
36033,
36295,
36384,
36389,
36436,
36470,
36547,
36557,
36648,
36885,
36938,
36954,
36970,
36989,
37002,
37031,
37179,
37209,
37521,
37539,
37675,
37687,
37803,
38010,
38012,
38162,
38323,
38433,
38485,
39044,
39379,
39464,
40041,
40084,
40154,
40706,
40898,
40943,
40969,
41144,
41154,
41436,
41458,
42061,
42137,
42165,
42180,
42462,
42520,
42666,
42680,
42768,
42885,
42996,
43011,
43224,
43227,
43405,
43486,
43553,
43583,
43847,
44628,
45859,
45919,
46520,
46531,
47941,
48584,
48705,
48774,
48811,
48832,
49060,
49209,
49330,
49673,
49956,
50048,
50359,
51743,
51756,
51962,
52444,
52475,
52477,
52588,
52606,
52609,
52679,
52717,
52829,
52923,
53022,
53068,
53274,
53368,
53489,
53560,
53561,
53828,
53960,
54213,
54386,
54639,
54763,
54919,
55002,
55851,
55905,
55908,
55977,
56236,
56308,
56479,
56575,
56647,
57000,
57108,
57158,
57336,
57341,
57373,
57535,
57574,
57623,
57643,
57690,
57803,
57859,
58024,
58070,
58222,
58282,
58372,
58412,
58618,
58902,
59020,
59288,
59294,
59358,
59379,
59445,
59462,
59493,
59597,
59917,
60096,
60142,
60192,
60266,
60379,
60447,
60534,
60599,
60883,
61155,
61284,
61467,
61694,
61742,
61900,
61925,
61962,
62154,
62230,
62256,
62344,
62449,
62522,
63594,
63673,
65066,
65406,
65446,
65462,
65476,
65694,
65772,
65830,
65846,
65891,
66155,
66648,
66711,
66735,
66811,
66914,
67219,
67325,
67625,
67645,
67802,
68129,
68169,
68455,
68516,
68588,
69134,
69212,
69403,
69485,
69838,
70414,
70501,
70596,
70699,
70705,
70773,
71056,
71244,
71298,
71558,
71899,
72582,
73056,
73474,
73865,
74181,
74503,
74625,
75144,
75367,
75673,
76070,
76096,
76098,
76134,
78975,
79355,
79372,
79460,
79469,
79483,
79687,
79731,
82852,
85899,
89646,
91144,
92275,
93886,
95041,
97838,
99669,
101045,
103454,
108306,
111129,
113931,
114087,
120450,
121727,
122360,
123804,
124208,
124569,
125092,
126355,
127406,
133116,
133842,
135052,
136171,
136933,
138275,
144566,
144740,
145842,
146375,
147012,
148990,
149124,
149126,
149793,
150085,
151633,
152744,
152939,
154351,
154810,
158513,
162490,
164657,
165110,
167388,
167731,
168418,
168709,
168762,
171961,
173829,
175250,
175887,
177133,
178425,
179136,
180389,
182379,
182934,
184715,
184889,
185831,
186663,
188447,
190319,
192814,
194201,
196387,
205055,
205854,
206735,
207137,
210963,
211890,
214703,
217507,
220061,
222949,
223362,
224158,
224320,
225653,
226024,
228493,
228644,
229500,
229603,
230189,
230483,
233829,
234682,
239378,
244069,
244740,
247774,
251279,
251813,
251903,
253373,
254255,
255633,
260819,
266113,
268481,
271226,
271814,
278448,
280098,
281457,
284901,
286440,
286848,
287335,
287997,
288133,
288982,
292388,
296455,
296507,
296885,
297560,
305728,
305867,
308186,
309899,
310145,
310399,
311431,
311898,
311932,
313123,
315530,
320493,
320526,
324879,
325983,
331092,
332976,
336014,
338219,
342426,
344809,
345677,
347674,
348130,
349159,
353178,
353627,
354338,
354556,
357257,
362740,
364388,
368491,
369141,
369945,
372344,
372457,
372953,
373869,
374694,
381721,
381932,
382934,
384155,
384489,
386467,
386951,
393607,
393665,
395549,
398646,
399702,
400213,
400351,
400862,
401771,
403408,
406077,
407037,
410510,
413225,
413320,
416320,
417429,
418618,
419555,
419929,
419967,
420029,
421734,
421925,
423003,
427057,
428050,
428865,
431358,
432723,
433288,
434021,
436876,
437198,
439114,
439944,
440953,
443571,
444502,
447442,
447554,
448580,
451152,
451884,
458248,
465850,
467596,
469265,
471701,
472525,
472741,
473079,
475591,
475669,
477125,
478500,
483768,
485950,
486040,
488614,
488632,
491085,
492111,
492140,
497783,
497848,
499777,
500125,
502071,
507901,
507903,
508144,
511060,
513451,
515240,
518402,
521296,
524623,
524718,
530927,
534026,
536424,
536468,
538277,
538939,
539942,
542185,
542360,
543172,
547544,
548285,
549040,
549291,
550250,
552593,
554040,
555704,
557855,
558690,
559701,
560346,
560748,
562528,
563251,
564008,
565108,
569003,
574702,
580480,
580833,
584633,
584791,
588545,
590662,
591972,
592901,
594442,
597307,
598009,
598520,
599421,
603153,
603775,
606726,
608510,
609285,
609723,
613861,
618805,
619142,
620520,
625379,
629168,
629501,
629576,
630138,
635727,
635762,
636965,
637059,
637620,
640552,
642443,
644652,
649720,
653342,
654074,
656669,
658502,
671788,
672206,
675821,
676295,
683677,
685194,
687246,
687845,
688371,
688975,
690341,
692176,
693110,
695451,
696238,
698391,
700780,
700981,
701739,
707296,
707638,
709055,
710080,
712717,
724795,
724862,
727393,
735542,
740011,
742253,
745145,
747322,
747977,
748534,
748926,
748928,
748932,
750124,
751954,
753668,
757181,
757421,
757906,
758591,
759239,
768147,
771567,
772553,
773549,
773914,
774213,
780645,
782357,
789537,
790852,
791131,
792784,
795143,
795292,
796302,
796512,
797332,
798450,
804767,
809902,
814741,
817224,
820900,
821671,
827396,
829285,
830407,
833376,
835422,
839605,
840806,
841023,
842515,
843128,
847684,
848368,
848477,
848730,
853151,
855289,
857797,
860194,
862671,
863109,
864170,
865990,
868021,
869703,
873485,
875395,
875396,
877885,
880707,
881602,
883629,
883893,
887671,
889150,
892395,
892423,
893584,
895337,
895524,
895766,
896292,
896329,
896825,
896911,
897112,
897734,
897853,
897958,
905664,
910267,
910528,
910808,
911249,
913968,
915530,
915735,
919529,
920248,
921767,
921912,
922092,
924895,
927286,
927824,
928586,
930188,
930214,
930276,
930302,
932197,
932660,
932677,
935116,
936689,
937527,
939162,
940725,
943223,
944377,
947578,
948990,
948992,
949340,
949395,
949635,
950762,
950957,
953056,
953605,
954868,
956148,
958961,
960624,
960659,
962902,
966050,
967099,
968550,
971352,
972690,
983390,
989291,
996824,
997986,
1005234,
1011777,
1015499,
1017003,
1017799,
1034245,
1043273,
1044626,
1048173,
1051210,
1053076,
1054637,
1060402,
1063172,
1065331,
1065895,
1073236,
1082104,
1088242,
1090082,
1094205,
1110083,
1115380,
1115797,
1159292,
1183589,
1186241,
1199310,
1199740,
1201853,
1258773,
1269568,
1276237,
1283654,
1303900,
1350779,
1383221,
1384042,
1392005,
1392306,
1393907,
1408219,
1408994,
1412717,
1415889,
1417396,
1449108,
1458410,
1475440,
1490636,
1504176,
1507349,
1532581,
1594749,
1666767,
1671944,
1689855,
1714397,
1720950,
1810817,
1828629,
1871152,
1879217,
1899131,
1900534,
1928873,
1936753,
1948837,
1956016,
1964165,
1968011,
1974221,
1976886,
1977806,
1984579,
1985701,
1989435,
1995783,
2015316,
2024944,
2031274,
2031459,
2031962,
2032299,
2032371,
2032843,
2035855,
2036305,
2036569,
2038913,
2046646,
2047213,
2047839,
2050444,
2051190,
2051335,
2054458,
2055239,
2058569,
2058888,
2066738,
2067085,
2079414,
2081067,
2084988,
2085034,
2088938,
2090458,
2091176,
2095516,
2103541,
2104600,
2111434,
2116235,
2126460,
2134361,
2134923,
2136859,
2151596,
2175344,
2204426,
2209549,
2211604,
2218088,
2224316,
2229129,
2230288,
2240809,
2254198,
2254708,
2259105,
2265195,
2270370,
2277717,
2278356,
2278429,
2278925,
2279033,
2279503,
2279787,
2279829,
2280023,
2280660,
2280759,
2281088,
2281103,
2281334,
2283082,
2284157,
2284516,
2287953,
2289503,
2292176,
2293217,
2294456,
2294503,
2294790,
2294963,
2295586,
2295799,
2295875,
2295998,
2303865,
2310006,
2319609,
2321799,
2333723,
2340651,
2356622,
2357003,
2358802,
2364731,
2365322,
2367833,
2368584,
2371040,
2372306,
2373847,
2374078,
2374347,
2377211,
2378018,
2379474,
2394092,
2397957,
2401390,
2403371,
2414277,
2416113,
2418238,
2421546,
2422172,
2425387,
2427283,
2427307,
2432130,
2434640,
2437464,
2438363,
2440749,
2443882,
2444309,
2444430,
2446018,
2448148,
2448654,
2451778,
2453227,
2454287,
2454492,
2454780,
2456583,
2457338,
2458866,
2460144,
2460171,
2460599,
2461029,
2461642,
2463442,
2463856,
2466002,
2466899,
2468791,
2470867,
2471484,
2473795,
2474613,
2474792,
2476065,
2477217,
2478174,
2481190,
2481622,
2483588,
2483731,
2488959,
2490478,
2490795,
2491638,
2492771,
2493747,
2494170,
2495224,
2495485,
2496539,
2496551,
2498519,
2500893,
2502662,
2504608,
2505510,
2505740,
2506117,
2508168,
2508480,
2509477,
2509508,
2512820,
2513717,
2514379,
2515639,
2516007,
2520578,
2520582,
2521184,
2521470,
2522593,
2527259,
2527603,
2527642,
2528212,
2533030,
2534033,
2541736,
2548734,
2548796,
2556831,
2561934,
2573948,
2593371,
2595652,
2607041,
2611068,
2631259,
2637787,
2672057,
2702003,
2724166,
2736449,
2741746,
2744753,
2745948,
2755400,
2758734,
2775448,
2785095,
2785129,
2793123,
2815754,
2820694,
2821109,
2821545,
2827953,
2834399,
2837278,
2843386,
2847970,
2853002,
2860690,
2874686,
2874787,
2880132,
2890151,
2899726,
2903564,
2912212,
2917358,
2930890,
2937579,
2938081,
2948478,
2948616,
2949135,
2964568,
2988288,
2989509,
2991486,
3005297,
3007402,
3012690,
3030130,
3039200,
3041659,
3053052,
3054189,
3057812,
3058052,
3062559,
3080815,
3084558,
3088242,
3101244,
3101263,
3101997,
3102588,
3104891,
3107757,
3112301,
3114101,
3123058,
3130653,
3147722,
3159832,
3168059,
3182923,
3192943,
3195597,
3195854,
3209309,
3212696,
3216182,
3249766,
3253636,
3262788,
3265257,
3272516,
3279039,
3287518,
3299665,
3306185,
3311852,
3327236,
3327895,
3329903,
3342460,
3343733,
3356837,
3382371,
3382374,
3384069,
3396856,
3398148,
3400100,
3402127,
3412474,
3414928,
3428254,
3435083,
3436682,
3447314,
3458941,
3462582,
3462607,
3464938,
3479209,
3484145,
3485813,
3496373,
3496958,
3499092,
3509537,
3514898,
3516481,
3524397,
3535054,
3566277,
3589804,
3590526,
3593612,
3606215,
3610959,
3612744,
3619429,
3622008,
3622308,
3623774,
3624141,
3626575,
3628645,
3637621,
3644814,
3646717,
3648403,
3648518,
3651865,
3652098,
3659343,
3659473,
3659606,
3662590,
3673645,
3675277,
3682974,
3685823,
3695724,
3701724,
3703061,
3704324,
3721120,
3727583,
3734778,
3740579,
3742238,
3749704,
3751680,
3753522,
3753872,
3772617,
3775048,
3777303,
3783806,
3785254,
3804180,
3804771,
3804910,
3805640,
3806188,
3806319,
3806374,
3806772,
3807463,
3810070,
3815441,
3817828,
3827900,
3832616,
3839300,
3840279,
3840740,
3852556,
3860847,
3861315,
3861459,
3873192,
3873456,
3875446,
3876356,
3878622,
3889016,
3890976,
3903516,
3904854,
3907823,
3911424,
3916798,
3918064,
3921699,
3931798,
3931819,
3937296,
3945093,
3953083,
3974264,
3974952,
3980923,
4140221,
4146075,
4154839,
4158269,
4166289,
4189355,
4197933,
4199572,
4214924,
4242742,
4270640,
4345640,
4395715,
4422729,
4579406,
4748972,
5059010,
5071914,
5159486,
5557123,
5644813,
5723289,
5813612,
5837996,
5862197,
5865822,
5934025,
5934862,
5946487,
5948942,
5960866,
5995605,
6000899,
6014026,
6024666,
68546,
288523,
480039,
897234,
914251,
932606,
2629789,
3003641,
3474118,
3751499,
3841786,
4044787,
4244792,
6099007,
578620,
630696,
956370,
1407408,
1447301,
1532763,
2294057,
2473900,
2562344,
2710594,
2714875,
3206938,
3281794,
3392947,
3693874,
3904336,
3983446,
4031254,
4588119,
5831260,
5989882,
6150617,
61348,
524936,
726296,
2788139,
3328549,
3640880,
3863882,
4496161,
4859662,
5269173,
6132130,
6168623,
6174105,
6599,
42134,
61276,
556603,
921473,
2029993,
2121934,
2679041,
3246688,
3433420,
3518265,
3640879,
3682680,
5498385,
5841554,
5884147,
6146371,
35930,
45900,
224645,
274779,
428832,
676742,
1829138,
2472526,
3159761,
3262951,
3380411,
3574875,
3586882,
3763919,
3858764,
3919483,
4264123,
5020990,
5876529,
5993234,
439030,
658234,
855764,
2686633,
2745990,
2927633,
3297324,
3376874,
3483237,
3931840,
5874869,
5993623,
76408,
110898,
318504,
2054980,
2058982,
2107896,
2718386,
3135770,
3306092,
3608925,
3959056,
3992356,
4268315,
5993760,
6074601,
6128835,
6174079,
13575,
30898,
34702,
40103,
57287,
62237,
560748,
701022,
950957,
3108793,
5798155,
5939591,
6013785,
6117199,
2414739,
2467069,
2772338,
3146814,
3606956,
3647007,
3885569,
5776530,
6214856,
59655,
239378,
796767,
849691,
1002879,
2435904,
2722007,
3151874,
3169260,
3436572,
3704180,
3791189,
4338321,
5534179,
5866125,
6112534,
6143197,
16098,
45865,
466013,
760199,
882902,
1285387,
2293054,
2762559,
3162877,
3978786,
5407325,
5793930,
5846828,
5966041,
6169395,
11897,
31655,
65370,
81569,
802638,
1377639,
2506855,
2642219,
2867193,
3839758,
3908068,
5900654,
6060477,
6127865,
6151015,
6176380,
33555,
73899,
419368,
682503,
2005342,
2792053,
2971940,
3516679,
3703853,
4557375,
5986392,
6032656,
6051892,
6155897,
11154,
14288,
26492,
29153,
30898,
33555,
35645,
57287,
61200,
65750,
67219,
69069,
76063,
105422,
124287,
144447,
162177,
177634,
194696,
205854,
239378,
344935,
364478,
411697,
433485,
473489,
526954,
545033,
547075,
617117,
619407,
631549,
647811,
740156,
758767,
776262,
878980,
907616,
947578,
1031810,
1086525,
1309801,
1879486,
1956043,
2034475,
2099198,
2128643,
2253046,
2279196,
2355568,
2365872,
2436633,
2501185,
2532039,
2575172,
2644211,
2684501,
2724556,
2729673,
2750555,
2783794,
2822346,
2938081,
3019765,
3021013,
3048769,
3071433,
3074369,
3108865,
3112180,
3161835,
3240097,
3248125,
3313085,
3315186,
3321992,
3332476,
3440310,
3451802,
3528462,
3597582,
3663307,
3666692,
3741635,
3768876,
3791955,
3819483,
3832518,
3838358,
3849620,
3865498,
3878614,
3889649,
3891020,
3897430,
3903622,
3910551,
3913236,
3918305,
3945987,
3946201,
3953446,
3957420,
3966067,
3974171,
3974275,
3986777,
3992356,
4059118,
4140518,
4142538,
4176483,
4180677,
4261922,
4270849,
4423139,
4452807,
4482874,
4672417,
4693819,
4818531,
5339519,
5793930,
3789,
4640,
12673,
34275,
35157,
226115,
254868,
328881,
342909,
356040,
388455,
498408,
530154,
703378,
882416,
956370,
1962379,
1973440,
2443315,
2617980,
2645579,
2774123,
2817624,
2850295,
3176536,
3199909,
3276258,
3323374,
3337870,
3401050,
3502078,
3506820,
3542603,
3565346,
3575818,
3602548,
3604727,
3705287,
3757557,
3811086,
3821909,
3895643,
3952506,
3957665,
3980663,
4158086,
4468948,
4661136,
5706331,
1204,
48553,
51705,
62806,
66461,
73299,
79131,
104576,
247700,
400200,
411305,
634318,
661612,
709055,
749383,
757533,
778753,
809305,
1202509,
1352512,
1818419,
2143595,
2228930,
2463395,
2598567,
2620026,
2624823,
2631222,
2685738,
2811190,
2818109,
2821009,
2913259,
2934796,
3073586,
3093915,
3119299,
3210545,
3340648,
3383021,
3423392,
3532771,
3572848,
3640880,
3641638,
3661975,
3665419,
3881970,
3919912,
3968255,
4112734,
4216460,
4381487,
4424919,
5287091,
5845278,
5914835
]

export_uids_by_org_id(org_ids)
