from collections import defaultdict
import datetime

from intranet.yandex_directory.src.yandex_directory.core.models import (
    OrganizationModel, OrganizationServiceModel, UserServiceLicenses,
    OrganizationLicenseConsumedInfoModel
)
from intranet.yandex_directory.src.yandex_directory.common.db import get_main_connection, get_shard_numbers
from intranet.yandex_directory.src.yandex_directory.core.models import UserModel, group
from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel

contact_fields = ('org_id', 'id', 'position', 'position_plain', 'first_name', 'last_name', 'middle_name', 'email',)


class FOrg(OrganizationServiceModel):
    db_alias = OrganizationServiceModel.db_alias
    all_fields = OrganizationServiceModel.all_fields
    table = OrganizationServiceModel.table
    date_fields = [
        'trial_expires',
        'last_mail_sent_at',
        'expires_at',
        'disabled_at',
        'enabled_at',
    ]
    select_related_fields = OrganizationServiceModel.select_related_fields
    prefetch_related_fields= OrganizationServiceModel.prefetch_related_fields
    field_dependencies = OrganizationServiceModel.field_dependencies
    fields_from_service_model = OrganizationServiceModel.fields_from_service_model

    def get_filters_data(self, filter_data):
        distinct, filter_parts, joins, used_filters = super().get_filters_data(filter_data)
        filter_func = self.filter_by(filter_data, filter_parts, used_filters)
        #import ipdb; ipdb.set_trace()
        filter_func('disabled_at')
        return distinct, filter_parts, joins, used_filters


def format_person(person, role):
    if person['middle_name']:
        fio = f"{person['last_name']} {person['first_name']} {person['middle_name']}"
    else:
        fio = f"{person['last_name']} {person['first_name']}"
    subrow = [
        fio,
        role,
        person['position_plain'] if person['position_plain'] else '-',
        person['email'],
    ]
    return subrow


def export_uids_by_org_id():
    tracker_id = 3
    org_info = {}

    for shard in get_shard_numbers():
        with get_main_connection(shard=shard) as main_connection:
            org_services = FOrg(main_connection).filter(
                service_id=tracker_id, enabled=False, disabled_at__gt=datetime.date(2020, 1, 1)
            ).fields(
                'org_id', 'enabled', 'enabled_at', 'disabled_at', 'disable_reason',
            )

            shard_org_ids = []

            id_to_org_service = {}
            for item in org_services:
                id_to_org_service[item['org_id']] = item
                shard_org_ids.append(item['org_id'])

            if not shard_org_ids:
                continue

            shard_orgs = OrganizationModel(main_connection).filter(id__in=shard_org_ids).fields(
                'id', 'name', 'organization_type', 'admin_uid', 'name', 'user_count',
            )

            for item in shard_orgs:
                org_id = item['id']
                license_count = UserServiceLicenses(main_connection).filter(org_id=org_id).count()
                owner = UserModel(main_connection).filter(id=item['admin_uid'], is_dismissed=False).fields(*contact_fields).one()
                group_model = group.GroupModel(main_connection)
                admin_group = group_model._connection.execute(
                    group.queries.GET_ORGANIZATION_ADMIN_GROUP['query'],
                    {'org_id': org_id}
                ).fetchone()
                if not admin_group:
                    continue
                admins = group_model.get_all_users(org_id=org_id, group_id=admin_group['id'])

                if not id_to_org_service[org_id]['enabled']:
                    last_consumed_date = (OrganizationLicenseConsumedInfoModel(main_connection).filter(org_id=org_id, service_id=tracker_id).order_by('-for_date').limit(1).one())
                    if last_consumed_date:
                        for_date = last_consumed_date['for_date']
                        license_count = OrganizationLicenseConsumedInfoModel(main_connection).filter(
                            org_id=org_id,
                            service_id=tracker_id,
                            for_date=for_date
                        ).count()
                        # if license_count != license_count_by_activity:
                        #     print(org_id, license_count, license_count_by_activity)

                org_info[org_id] = {
                    'org_id': org_id,
                    'org_name': item['name'],
                    'org_type': item['organization_type'],
                    'users_count': item['user_count'],
                    'is_big': item['user_count'] >= 100,
                    'tracker_status': id_to_org_service[org_id]['enabled'],
                    'enabled_at': id_to_org_service[org_id]['enabled_at'],
                    'disabled_at': id_to_org_service[org_id]['disabled_at'],
                    'disabled_reason': id_to_org_service[org_id]['disable_reason'],
                    'license_count': license_count,
                    'owner': owner,
                    'admins': admins,
                }

    header = [
        'org_id',
        'org_name',
        'org_type',
        'users_count',
        'is_100_plus',
        'tracker_status',
        'license_count',
        'disabled_reason',
        'enabled_at',
        'disabled_at',
    ]

    contact_block = [
        'contact_fio',
        'contact_role',
        'contact_position',
        'contact_email',
    ]
    #print(';'.join(header))

    rows = []
    max_admin_count = 0
    for org_id, info in org_info.items():
        result_row = [
            str(info['org_id']),
            info['org_name'],
            info['org_type'],
            str(info['users_count']),
            'да' if info['is_big'] else 'нет',
            'да' if info['tracker_status'] else 'нет',
            str(info['license_count']),
            str(info['disabled_reason']),
            info['enabled_at'].strftime('%d.%m.%Y') if info['enabled_at'] else '',
            info['disabled_at'].strftime('%d.%m.%Y') if info['disabled_at'] else '',
        ]

        if info['owner']:
            result_row.extend(format_person(info['owner'], 'owner'))

        max_admin_count = max(max_admin_count, len(info['admins']))
        for admin in info['admins']:
            if info['owner'] and admin['id'] != info['owner']['id']:
                result_row.extend(format_person(admin, 'admin'))
        rows.append(result_row)

    header.extend(contact_block * (max_admin_count + 1))
    # print('\ufeff')  # bom
    print(';'.join(header))
    for row in rows:
        print(';'.join(row))


export_uids_by_org_id()
