from intranet.yandex_directory.src.yandex_directory.core.models import OrganizationMetaModel
from intranet.yandex_directory.src.yandex_directory.common.db import get_meta_connection, get_main_connection
from intranet.yandex_directory.src.yandex_directory.core.models import UserModel


def export_uids_by_org_id(org_id):
    with get_meta_connection() as meta_connection:
        organization_meta = OrganizationMetaModel(meta_connection).get(org_id)
        shard = organization_meta['shard']
    with get_main_connection(shard=shard) as main_connection:
        data = UserModel(main_connection).filter(org_id=org_id, is_dismissed=False).fields('id')
        result = '\n'.join([str(fields['id']) for fields in data])
    print(result)
