# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    get_localhost_ip_address,
    get_user_id_from_passport_by_login,
)
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option
from pprint import pprint
from intranet.yandex_directory.src.yandex_directory import app
import requests


class PassportRegister(object):
    #  https://wiki.yandex-team.ru/passport/api/bundle/registration/#registracijapolzovateljadljadirektoriijandeks.workspace
    # (Команда работает только для тестового окружения, потому что на прод - грантов от паспорта пока нет)
    def __init__(self, domain_label):
        # гранты дали для pddback консьюмера
        self.domain_label = domain_label
        base_url = app.config['PASSPORT_API']
        self.url = base_url + '%s?consumer=pddback'
        self.headers = {
            'Ya-Consumer-Client-Ip': get_localhost_ip_address(),
            'Ya-Client-User-Agent': 'yandex.ru',
        }

    def get_track(self):
        url = self.url % '1/track/'
        response = requests.post(url, headers=self.headers).json()
        return response.get('id')

    def get_phone_code(self, track_id, phone_number='70000416888'):
        url = self.url % '1/bundle/phone/confirm/submit/'
        data = {
            'display_language': 'ru',
            'number': phone_number,
            'track_id': track_id,
        }
        response = requests.post(url, data=data, headers=self.headers).json()

        if response.get('status') != 'ok':
            pprint(response)
            return

        url = self.url % '1/bundle/test/track/'
        params = {
            'track_id': track_id,
        }
        response = requests.get(url, params=params, headers=self.headers).json()
        if response.get('status') != 'ok':
            pprint(response)
            return

        return response.get('phone_confirmation_code')

    def phone_confirmation(self, track_id, phone_code):
        # https://wiki.yandex-team.ru/users/gladnik/test-users-api-manual/
        url = self.url % '1/bundle/phone/confirm/commit/'
        data = {
            'code': phone_code,
            'track_id': track_id,
        }
        response = requests.post(url, data=data, headers=self.headers).json()
        return response.get('status') == 'ok'

    def account_register(self):
        track_id = self.get_track()
        phone_code = self.get_phone_code(track_id)
        if not self.phone_confirmation(track_id, phone_code):
            return None

        url = self.url % '1/bundle/account/register/directory/'
        data = {
            'firstname': 'Admin',
            'lastname': 'Adminovich',
            'domain': '%s.yaconnect.com' % self.domain_label,
            'login': 'admin',
            'password': '051292',
            'organization': 'Test',
            'eula_accepted': True,
            'track_id': track_id,
        }
        response = requests.post(url, data=data, headers=self.headers).json()

        if response.get('status') != 'ok':
            pprint(response)
            return

        return response.get('uid')


class Command(BaseCommand):
    """
    Создаем новую организацию с нуля через методы для паспортного лендинга
    """
    option_list = (
        Option('label', help='Label is required.'),
        Option(
            '--reuse',
            '-r',
            dest='reuse',
            default=False,
            type=bool,
            help='Reuse existed organization',
        ),
    )
    name = 'passport-org'

    def run(self, label=None, reuse=False):
        if reuse:
            admin_login = 'admin@%s.yaconnect.com' % label
            admin_uid = get_user_id_from_passport_by_login(admin_login)
        else:
            p = PassportRegister(domain_label=label)
            admin_uid = p.account_register()

        print("admin_uid = ", admin_uid)
        directory_url = app.config['SITE_BASE_URI'] + 'organization/'
        data = {
            'name': 'test',
            'language': 'ru',
            'country': 'ru',
        }
        headers = {
            'X-UID': admin_uid,
            'X-USER-IP': get_localhost_ip_address(),
            'X-REAL-IP': get_localhost_ip_address(),
            # для этого заголовка нужно прописать такой json в /etc/yandex/tokens.json: {"swagger": "swagger"}
            'Authorization': 'token swagger',
        }

        response = requests.post(directory_url, json=data, headers=headers)
        if response.status_code == 401:
            print("You need to put {'swagger':'swagger'} into /etc/yandex/tokens.json file, for example.")
            return

        print(response.json())
