# -*- coding: utf-8 -*-
import tqdm

from intranet.yandex_directory.src.yandex_directory.core.models import (
    UserModel,
    GroupModel,
)
from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand


class Command(AllShardsCommand):
    """
    Удаляет из админов команд все учётки уволенных сотрудников.

    Эту команду надо запустить один раз, чтобы устранить неконсистентность
    данных.
    """
    name = 'remove-dismissed-group-admins'

    def run(self):
        users = UserModel(self.main_connection).find(
            {'is_dismissed': True},
            fields=['org_id', 'id']
        )
        group_m = GroupModel(self.main_connection)

        users = tqdm.tqdm(users)
        for user in users:
            group_m.remove_admin_from_all_groups(
                user['org_id'],
                user['id'],
            )
