# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.commands.base import (
    BaseCommand,
    Option,
)
from intranet.yandex_directory.src.yandex_directory.core.utils.tasks import (
    save_analytics,
    TABLE_MODEL_MAP,
)


class Command(BaseCommand):
    """
    Создает таски на сохранение данных локально и ставит таск на копирование их в YT.
    Если задан параметр table, то сохраняем данные только для одной таблицы и копируем их в YT.
    """
    name = 'save-analytics'
    option_list = (
        Option('--table', '-t', dest='table', required=False,
               help='Локальная таблица с аналитикой', choices=list(TABLE_MODEL_MAP.keys())),
        Option('--force', '-f', dest='recreate', action='store_true',
               help='Пересоздать таблицы в YT', required=False),
        Option('--progress', '-p', dest='show_progress', action='store_true', help='Show progress'),
        Option('--yt', '-yt', dest='copy_to_yt', action='store_true', help='Copy to yt'),
    )

    def run(self, table=None, recreate=False, show_progress=False, copy_to_yt=False):
        save_analytics(table, recreate, show_progress, copy_to_yt)
