# -*- coding: utf-8 -*-

import datetime
import sys

from intranet.yandex_directory.src.yandex_directory.common.commands.base import (
    BaseCommand,
    Option,
)
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_main_connection,
    get_shard_numbers,
)
from intranet.yandex_directory.src.yandex_directory.core.utils.tasks import SaveAnalyticsToYTTask


def check_shard(shard, for_date):
    with get_main_connection(shard=shard, for_write=True) as c:
        count = c.execute('select count(*) from organizations_analytics_info where for_date = %s', (for_date,)).fetchall()[0][0]
        print('Shard {}: {}'.format(shard, count))
        return count > 0


def check_if_all_data_present_in_db(for_date):
    shards = get_shard_numbers()

    print('Checking data in shards')
    results = []
    for shard in shards:
        results.append(check_shard(shard, for_date))

    if not all(results):
        print('Missing data! Interrupting the procedure! Please, use manage save-analytics instead.')
        sys.exit(1)


class Command(BaseCommand):
    name = 'save-analytics-to-yt'
    option_list = (
        Option('--date', '-d', dest='date', required=False),
        Option('--force', '-f', dest='recreate', action='store_true', required=False),
    )

    def run(self, date=None, recreate=False):
        # запускаем на одном шарде, потому что сам таск внутри ходит по всем шардам
        date = date or str(datetime.date.today())

        check_if_all_data_present_in_db(date)

        with get_main_connection(shard=get_shard_numbers()[0], for_write=True) as main_connection:
            SaveAnalyticsToYTTask(main_connection).delay(for_date=date, recreate=recreate)
