# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.commands.base import TransactionalCommand, Option
from intranet.yandex_directory.src.yandex_directory.core.models import ServiceModel


class Command(TransactionalCommand):
    name = 'service-add'
    option_list = (
        Option('client_id', help='OAuth client id.',),
        Option('slug'),
        Option('name'),
        Option(
            '--shard',
            '-s',
            dest='shard',
            type=int,
            required=False,
            default=1,
            help='Shard number.',
        ),
        Option(
            '--robot-required',
            '-r',
            dest='robot_required',
            type=bool,
            required=False,
            default=False,
            help='Is a robot account required?',
        )
    )

    def run(self, client_id, slug, name, robot_required=False, shard=1):
        ServiceModel(self.meta_connection).create(
            slug=slug,
            name=name,
            robot_required=robot_required,
            client_id=client_id,
        )
