# -*- coding: utf-8 -*-
import tqdm

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option
from intranet.yandex_directory.src.yandex_directory.core.models.user import get_external_org_ids
from intranet.yandex_directory.src.yandex_directory.common.db import get_meta_connection


def process(meta_connection, user_id):
    org_ids = get_external_org_ids(meta_connection, user_id)
    app.passport.set_organization_ids(user_id, org_ids)
    

class Command(BaseCommand):
    """Одноразовая команда, нужна для того, чтобы проставить всем "портальным" сотрудникам external_org_ids в паспорте
       https://st.yandex-team.ru/DIR-6080
    """
    name = 'set-external-org-ids'
    option_list = (
        Option('--progress', dest='progress', action='store_true', help='Show progress'),
    )

    def run(self, progress=False, limit=None, *args, **kwargs):
        with get_meta_connection() as meta_connection:
            results = meta_connection.execute(
                """
                SELECT id
                  FROM users
                 WHERE user_type = 'inner_user'
                   AND id < 1120000000000000
                """)
            rows = results.fetchall()
            if progress:
                rows = tqdm.tqdm(rows)

            for user_id, in rows:
                process(meta_connection, user_id)
