# -*- coding: utf-8 -*-

import sys
import os
import subprocess
import json
import re

from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option


def analyze(lines):
    total = 0
    for line in lines:
        time = analyze_line(line)
        total += time

    print('Total:', total)


def analyze_file(filename):
    with open(filename) as f:
        analyze(f)


def analyze_text(text):
    lines = text.split('\n')
    lines = [_f for _f in lines if _f]
    analyze(lines)


def parse_metric(text):
    match = re.match(r'^metric=sql query="(?P<sql>.*)" value=(?P<time>.*)$', text)
    if match:
        return (
            'sql',
            match.group('sql').decode('string_escape'),
            float(match.group('time'))
        )
    return None, None, None


def add_padding(text, padding=4):
    lines = text.split('\n')
    padding_text = ' ' * padding
    padded_lines = (padding_text + line
                    for line in lines)
    new_text = '\n'.join(padded_lines)
    return new_text


def analyze_line(line):
    data = json.loads(line)
    fields = data.get('@fields', {})

    if 'query' in fields:
        query = fields['query']
        time = fields['total_time'] * 1000
        print('{:.2f}\n{}\n'.format(time,  add_padding(query)))
        return time
    return 0


class Command(BaseCommand):
    """Эта команда показывает в читаемом виде SQL запросы из лога Директории.

    Сначала записи лога фильтруются по указанному request_id, чтобы
    залоггировались SQL запросы с временами ответа, надо в запросах
    к директории передавать заголовок "X-Debug: 1".

    Затем из ответа надо вынуть содержимое заголовка "X-Request-ID"
    и передать его в качестве аргумента этой команде.
    """
    name = 'show-metrics'

    option_list = (
        Option('request_id', help='ID запроса'),
        Option('--log',
               '-l',
               dest='filename',
               help='Опциональный путь до файла с логом',
               default='/var/log/yandex-directory/all.log',
        ),
    )
    def run(self, request_id, filename):
        if not os.path.exists(filename):
            print('File "{0}" not found.'.format(
                filename
            ))
            sys.exit(1)

        cmd = 'grep {0} {1}'.format(
            request_id,
            filename,
        )
        output = subprocess.check_output(cmd, shell=True)
        analyze_text(output)
