# coding: utf-8
import json
import datetime

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory import app

from intranet.yandex_directory.src.yandex_directory.common.commands.base import Option
from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand
from intranet.yandex_directory.src.yandex_directory.common.utils import utcnow, get_user_data_from_blackbox_by_uid
from intranet.yandex_directory.src.yandex_directory.common import http_client

DEFAULT_SURVEY_KEY = 'automigration_survey_status'


def _make_request(method, uid, data):
    # Надо будет вернуть эти закомменченый строки обратно,
    # а то что выше захардкожено - выпилить перед тем, как мерджить пулл
    # они нужны только для ручного запуска скрипта, положенного в COMMANDS_DIR,
    # так как в продакшеновой версии Директории просто нет таких настроек.
    settings_url = app.config['SETTINGS_WS_URL']
    token = app.config['SETTINGS_WS_TOKEN']

    token = TOKEN
    headers = {
        'X-UID': uid,
        'Authorization': 'token {}'.format(token),
        'Content-type': 'application/json',
    }
    response = http_client.request(method, settings_url, data=json.dumps(data), headers=headers)
    return response.json()


def set_survey_key(uid, survey_key):
    current_settings = _make_request('get', uid, data=None)
    if survey_key not in current_settings or True:
        current_settings[survey_key] = 'required'
        _make_request('put', uid, data=current_settings)
        return True


class Command(AllShardsCommand):
    """
    Админам автомигрироваших организаций проставляем флаг в сервисе настроек, чтобы показывать опрос
    """
    name = 'show-survey-for-automigrated'

    option_list = (
        Option('--num-admins',  dest='num_admins', type=int, required=True),
        Option('--verbose',  dest='verbose', action='store_true'),
        Option('--no-dry-run',  dest='no_dry_run', action='store_true'),
        Option('--before', default='2018-06-29'),
        Option('--survey-key', default=DEFAULT_SURVEY_KEY),
        Option('--environment'),
    )

    def __init__(self, *args, **kwargs):
        super(Command, self).__init__(*args, **kwargs)
        # поскольку тут мы идём по шардам, то здесь будем подсчитывать
        # у скольких админов включили опцию
        self.processed = 0

    def run(self, num_admins, verbose, no_dry_run, before, environment, survey_key):
        print('Обрабатываю {0} шард'.format(self.shard))
        before = utcnow() - datetime.timedelta(days=30)

        if not environment:
            environment = app.config['ENVIRONMENT']

        admin_uids = self.main_connection.execute(
            """
            SELECT DISTINCT admin_uid FROM organizations
             WHERE source='auto'
               AND created < %(before)s
               AND environment = %(environment)s
             ORDER BY admin_uid
            """,
            before=before,
            environment=environment,
        ).fetchall()

        # Из каждого следующего шарда будем стараться добрать нужное количество админов
        limit = num_admins - self.processed

        shard_error_count = 0
        shard_processed = 0
        for row in admin_uids:
            # Если обработали заданное число админов, то на этом работу прекращаем
            if self.processed >= num_admins:
                break

            uid = row[0]
            try:
                if not no_dry_run or set_survey_key(uid, survey_key):
                    if verbose:
                        login = get_user_data_from_blackbox_by_uid(uid)['login']
                        print('  ', uid, login)
                    shard_processed += 1
                    self.processed += 1
            except:
                shard_error_count += 1
                log.trace().error('Unhandled exception for uid {}'. format(uid))
        if shard_error_count > 0:
            print('  {} ошибок в {} шарде, загляните в логи'.format(
                shard_error_count,
                self.main_connection.engine.db_info['shard']
            ))
        if shard_processed > 0:
            print('  Обработано:', shard_processed)
        else:
            print('  В этом шарде админов не найдено')

