# -*- coding: utf-8 -*-
import sys

from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option
from intranet.yandex_directory.src.yandex_directory.core.task_queue.base import TaskType


DEFAULT_ORDERING = 'name'

ORDERING_FUNCS = {
    'name': lambda name, task_type: name,
    'priority': lambda name, task_type: task_type.default_priority,
}


def short(name):
    prefix = 'intranet.yandex_directory.src.yandex_directory'
    if name.startswith(prefix):
        return name[len(prefix):]
    return name


class Command(BaseCommand):
    """
    Получить список типов задач и их приоритеты.
    """
    name = 'task-types'

    option_list = (
        Option('--order', '-o', type=str, help='порядок сортировки', default=DEFAULT_ORDERING),
        Option('--verbose', '-v', action='store_true', help='показать дополнительные данные'),
    )

    def run(self, order, verbose):
        ordering_func = ORDERING_FUNCS.get(order)
        if ordering_func is None:
            print('Сортировка по {0} не поддерживается. Доступны: {1}'.format(
                order,
                ', '.join(sorted(ORDERING_FUNCS.keys()))
            ))
            sys.exit(1)

        items = list(TaskType.task_types.items())
        items = sorted(items, None, lambda item: ordering_func(item[0], item[1]))
        
        for name, task in items:
            print(short(name))
            print('  priority={0}'.format(task.default_priority))
            if verbose:
                print('  singleton={0}'.format(task.singleton))
                print('  tries={0}'.format(task.tries))
                print('  tries_delay={0}'.format(task.tries_delay))
                print('  lock_ttl={0}'.format(task.lock_ttl))
