# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.core.models import (
    ServiceModel,
)
from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand


class Command(AllShardsCommand):
    """
    Копируем значения services c meta на шард.
    """
    name = 'update-services'

    def run(self):
        meta_service_model = ServiceModel(self.meta_connection)
        main_service_model = ServiceModel(self.main_connection)

        services = meta_service_model.find(
            fields=['*'],
        )

        main_service_ids = main_service_model.find(
            fields=['id']
        )
        main_service_ids = [service['id'] for service in main_service_ids]

        updated_services_ids = []
        for service in services:
            if service['id'] in main_service_ids:
                # Обновляем существующие записи
                main_service_model.update(
                    update_data=service,
                    filter_data={'id': service['id']},
                )
                updated_services_ids.append(service['id'])
            else:
                # Создаём недостающие записи
                main_service_model.create(**service)

        # Удаляем ненужные записи.
        for service_id in main_service_ids:
            if service_id not in updated_services_ids:
                main_service_model.delete(filter_data={'id':service_id})
