-- This way, groups will be able to contain any user, group or department.

ALTER TABLE ydir.groups
      ADD COLUMN resource_id TEXT,
      ADD CONSTRAINT fk_groups_resource_id
          FOREIGN KEY (resource_id) REFERENCES ydir.resources (id);



-- This trigger will remove a resource bound to deleted group

CREATE OR REPLACE FUNCTION ydir.delete_group_resource_trigger()
RETURNS trigger LANGUAGE plpgsql AS $$
BEGIN

    DELETE FROM ydir.resources WHERE id=OLD.resource_id;
    RETURN NEW;

END;
$$;

CREATE TRIGGER delete_group_resource
       AFTER DELETE ON ydir.groups
       FOR EACH ROW EXECUTE PROCEDURE ydir.delete_group_resource_trigger();

