CREATE INDEX i_users_search_idx ON ydir.users USING gin(to_tsvector('english',
    coalesce(users.name #>> '{{first, en}}', '') || ' ' ||
    coalesce(users.name #>> '{{last, en}}', '') || ' ' ||
    coalesce(users.name #>> '{{first, ru}}', '') || ' ' ||
    coalesce(users.name #>> '{{last, ru}}', '') || ' ' || login));

DROP INDEX ydir.i_users_firstru_idx;
DROP INDEX ydir.i_users_lastru_idx;
DROP INDEX ydir.i_users_nameen_idx;
DROP INDEX ydir.i_users_nameru_idx;

CREATE INDEX i_groups_search_idx ON ydir.groups USING gin(to_tsvector
    ('english',
    coalesce(groups.name ->> 'ru', '') || ' ' ||
    coalesce(groups.name ->> 'en', '') || ' ' ||
    coalesce(groups.label, '')));

DROP INDEX ydir.groupnameru_idx;
DROP INDEX ydir.groupnameen_idx;
