DROP INDEX ydir.i_users_search_idx;
DROP INDEX ydir.i_groups_search_idx;

CREATE INDEX i_users_search_idx ON ydir.users USING gin(to_tsvector('russian',
    coalesce(users.name #>> '{{first, en}}', '') || ' ' ||
    coalesce(users.name #>> '{{last, en}}', '') || ' ' ||
    coalesce(users.name #>> '{{first, ru}}', '') || ' ' ||
    coalesce(users.name #>> '{{last, ru}}', '') || ' ' || login));

CREATE INDEX i_groups_search_idx ON ydir.groups USING gin(to_tsvector
    ('russian',
    coalesce(groups.name ->> 'ru', '') || ' ' ||
    coalesce(groups.name ->> 'en', '') || ' ' ||
    coalesce(groups.label, '')));
