ALTER TABLE ydir.users
    ADD COLUMN aliases JSONB,
    ADD COLUMN nickname TEXT;

UPDATE ydir.users SET nickname = login;

ALTER TABLE ydir.users
    ALTER COLUMN nickname SET NOT NULL;
ALTER TABLE ydir.users
    ALTER COLUMN login DROP NOT NULL;

DROP INDEX ydir.i_users_search_idx;

CREATE INDEX i_users_search_idx ON ydir.users USING gin(to_tsvector('simple',
    coalesce(users.name #>> '{{first, en}}', '') || ' ' ||
    coalesce(users.name #>> '{{last, en}}', '') || ' ' ||
    coalesce(users.name #>> '{{first, ru}}', '') || ' ' ||
    coalesce(users.name #>> '{{last, ru}}', '') || ' ' || nickname));
