-- for migration from pdd

DROP TYPE IF EXISTS migration_state;

CREATE TYPE migration_state AS ENUM (
    'setup',
    'migration',
    'finalization',
    'completed',
    'rollback',
    'rollback_completed',
    'error'
);

CREATE TABLE ydir.migrations (
    org_id BIGINT NOT NULL,
    state migration_state NOT NULL,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
    updated_at TIMESTAMP WITH TIME ZONE DEFAULT now(),

    CONSTRAINT pk_migrations PRIMARY KEY (org_id)
);


CREATE TABLE ydir.migrate_emails (
    id BIGSERIAL NOT NULL,
    org_id BIGINT NOT NULL,
    email TEXT NOT NULL,
    email_data JSONB NOT NULL,
    migrated BOOLEAN,
    error TEXT,

    CONSTRAINT fk_migrate_emails_org_id_organizations_id
        FOREIGN KEY (org_id) REFERENCES ydir.organizations (id)
);

CREATE UNIQUE INDEX uk_org_id_email ON ydir.migrate_emails (org_id, email);


CREATE TABLE ydir.migrate_log (
    id BIGSERIAL NOT NULL,
    org_id BIGINT NOT NULL,
    event TEXT NOT NULL,
    timestamp TIMESTAMP WITH TIME ZONE,
    params JSONB
)