CREATE TABLE ydir.users_dismissed_info (
    org_id BIGINT NOT NULL,
    user_id BIGINT NOT NULL,
    dismissed_date TIMESTAMP WITH TIME ZONE DEFAULT now(),
    department jsonb,
    groups jsonb,
    groups_admin jsonb,

    CONSTRAINT pk_users_dismissed_info PRIMARY KEY (user_id),
    CONSTRAINT fk_users_dismissed_info_org_id
        FOREIGN KEY (org_id) REFERENCES ydir.organizations (id)
        ON DELETE CASCADE,
    CONSTRAINT fk_users_dismissed_info_user_id
        FOREIGN KEY (user_id) REFERENCES ydir.users (id)
        ON DELETE CASCADE
);

CREATE UNIQUE INDEX uk_users_dismissed_info_user_id ON ydir.users_dismissed_info (user_id);

GRANT ALL ON ALL TABLES IN SCHEMA ydir TO ydir;