DROP TABLE ydir.migrations;

DROP TYPE IF EXISTS migration_state;

CREATE TYPE migration_state AS ENUM (
    'setup',
    'migration',
    'finalization',
    'completed',
    'rollback',
    'rollback_completed',
    'error'
);

CREATE TABLE ydir.migrations (
    org_id BIGINT NOT NULL,
    state migration_state NOT NULL,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
    updated_at TIMESTAMP WITH TIME ZONE DEFAULT now(),

    CONSTRAINT pk_migrations PRIMARY KEY (org_id)
);