
TRUNCATE TABLE migrate_emails;
TRUNCATE TABLE migrate_log;

DROP TABLE ydir.migrations;

DROP TYPE IF EXISTS migration_status;

CREATE TYPE migration_status AS ENUM (
    'setup',
    'migration',
    'finalization',
    'completed',
    'rollback',
    'rollback_completed',
    'error',
    'check',
    'ready',
    'domain_not_owned',
    'not_master_admin',
    'domain_is_alias',
    'already_migrated',
    'admin_does_not_exist',
    'domain_already_exists',
    'organization_too_large',
    'has_paid_disk'
);

CREATE TABLE ydir.migrations (
    id text,
    org_id BIGINT,
    status migration_status NOT NULL,
    settings JSONB NOT NULL DEFAULT JSONB('{}'),
    data JSONB NOT NULL DEFAULT JSONB('{}'),
    only_check_conditions BOOLEAN NOT NULL DEFAULT TRUE,

    created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
    updated_at TIMESTAMP WITH TIME ZONE DEFAULT now(),

    CONSTRAINT pk_migrations PRIMARY KEY (id)
);

CREATE UNIQUE INDEX migrations_org_id ON ydir.migrations (org_id);
CREATE INDEX i_migrations_status_idx ON migrations (status);