ALTER TABLE ydir.users ADD COLUMN external_id TEXT CHECK (length(external_id) <100);
ALTER TABLE ydir.groups ADD COLUMN external_id TEXT CHECK (length(external_id) <100);
ALTER TABLE ydir.departments ADD COLUMN external_id TEXT CHECK (length(external_id) <100);

CREATE UNIQUE INDEX groups_org_id_external_id_unique_index
  ON ydir.groups(org_id, external_id)
  WHERE external_id IS NOT NULL;

CREATE UNIQUE INDEX users_org_id_external_id_unique_index
  ON ydir.users(org_id, external_id)
  WHERE external_id IS NOT NULL;

CREATE UNIQUE INDEX departments_org_id_external_id_unique_index
   ON ydir.departments(org_id, external_id)
   WHERE external_id IS NOT NULL;
