/*
+----+--------------------+        +----+--------------------+
| id |                    |        | id | name               |
|----+--------------------|        |----+--------------------|
|  1 | department_deleted |        |  1 | event1             |
|  2 | event1             |   ->   |  2 | event2             |
|  3 | event2             |        |  3 | event3             |
|  4 | event3             |        |  4 | department_deleted |
+----+--------------------+        +----+--------------------+
*/

UPDATE events as evnts
SET name=tt.name, content=tt.content, object_type=tt.object_type, object=tt.object, timestamp=tt.timestamp
FROM (
	select e.org_id, e.revision, e.name, e.content, e.object_type, e.object, e.timestamp,
		COALESCE(
			(select id from events where id<e.id and org_id=e.org_id and revision=e.revision  order by id desc limit 1),
			(select max(events.id) as id from events where org_id=e.org_id and revision=e.revision limit 1)
		) as new_id
	from events as e
	inner join (
		select distinct e1.org_id, e1.revision from events as e1
		inner join events as e2 on e2.org_id = e1.org_id and e2.revision = e1.revision  and e2.id>e1.id
		where e1.name='group_deleted'
	) as gr_e on gr_e.org_id = e.org_id and gr_e.revision = e.revision
	order by e.org_id, e.revision, e.id
) as tt
WHERE evnts.id=tt.new_id and evnts.org_id=tt.org_id and evnts.revision=tt.revision;


UPDATE events as evnts
SET name=tt.name, content=tt.content, object_type=tt.object_type, object=tt.object, timestamp=tt.timestamp
FROM (
	select  e.org_id, e.revision, e.name, e.content, e.object_type, e.object, e.timestamp,
		COALESCE(
			(select id from events where id<e.id and org_id=e.org_id and revision=e.revision  order by id desc limit 1),
			(select max(events.id) as id from events where org_id=e.org_id and revision=e.revision limit 1)
		) as new_id
	from events as e
	inner join (
		select distinct e1.org_id, e1.revision from events as e1
		inner join events as e2 on e2.org_id = e1.org_id and e2.revision = e1.revision  and e2.id>e1.id
		where e1.name='department_deleted'
	) as gr_e on gr_e.org_id = e.org_id and gr_e.revision = e.revision
	order by e.org_id, e.revision, e.id
) as tt
WHERE evnts.id=tt.new_id and evnts.org_id=tt.org_id and evnts.revision=tt.revision;