
CREATE TABLE ydir.tasks (
  id uuid,

  task_name text NOT NULL,
  worker text,
  queue text NOT NULL DEFAULT 'default',

  params JSONB NOT NULL DEFAULT JSONB('{}'),
  state text NOT NULL DEFAULT 'free',
  result text,
  exception text,
  ttl int DEFAULT 60,

  start_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT NOW(),
  locked_at TIMESTAMP WITH TIME ZONE,
  free_lock_at TIMESTAMP WITH TIME ZONE,

  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  finished_at TIMESTAMP WITH TIME ZONE,

  tries int NOT NULL CHECK (tries>=0) DEFAULT 0,
  rollback_tries int NOT NULL CHECK (tries>=0) DEFAULT 0,

  PRIMARY KEY (id)
)
