ALTER TABLE users
  ADD COLUMN created TIMESTAMP WITH TIME ZONE DEFAULT now();

ALTER TABLE departments
  ADD COLUMN created TIMESTAMP WITH TIME ZONE DEFAULT now();

UPDATE users SET created=first_org_action.timestamp
FROM (
    SELECT org_id, min(timestamp) as timestamp FROM actions
    GROUP BY org_id
) as first_org_action
WHERE users.org_id=first_org_action.org_id;

UPDATE departments SET created=first_org_action.timestamp
FROM (
    SELECT org_id, min(timestamp) as timestamp FROM actions
    GROUP BY org_id
) as first_org_action
WHERE departments.org_id=first_org_action.org_id;

UPDATE users SET created=first_action.timestamp
FROM (
    SELECT org_id, object->>'id' as id, min(timestamp) as timestamp FROM actions
    WHERE object_type='user' and name='user_add'
    GROUP BY org_id, object->>'id'
) as first_action
WHERE users.org_id=first_action.org_id and users.id=first_action.id::bigint;


UPDATE departments SET created=first_action.timestamp
FROM (
    SELECT org_id, object->>'id' as id, min(timestamp) as timestamp FROM actions
    WHERE object_type='department' and name='department_add'
    GROUP BY org_id, object->>'id'
) as first_action
WHERE departments.org_id=first_action.org_id and departments.id=first_action.id::integer;