ALTER TABLE ydir.organizations ADD COLUMN disk_usage BIGINT NOT NULL DEFAULT 0;
ALTER TABLE ydir.organizations ADD COLUMN disk_limit BIGINT NOT NULL DEFAULT 0;

CREATE TABLE ydir.disk_usage (
       id BIGSERIAL NOT NULL,
       org_id BIGINT NOT NULL
              REFERENCES ydir.organizations
              ON DELETE CASCADE,
       service_id BIGINT NOT NULL,
       usage BIGINT NOT NULL DEFAULT 0,
       updated TIMESTAMP WITH TIME ZONE DEFAULT now(),

       CONSTRAINT pk_disk_usage PRIMARY KEY (id),
       UNIQUE (org_id, service_id)
);
