DO $$
BEGIN
  IF NOT EXISTS (SELECT 1 FROM pg_type WHERE typname = 'contract_type')
  THEN
     CREATE TYPE contract_type AS ENUM ('contract', 'offer');
  END IF;
END
$$;

CREATE TABLE ydir.organizations_billing_info (
    org_id BIGSERIAL PRIMARY KEY,
    client_id BIGSERIAL NOT NULL,
    person_id BIGSERIAL NOT NULL,
    contract_id VARCHAR(255) NOT NULL,
    is_contract_active BOOLEAN NOT NULL DEFAULT FALSE,
    contract_type contract_type NOT NULL,

    CONSTRAINT fk_organzation_billing_info_org_id
        FOREIGN KEY (org_id) REFERENCES ydir.organizations (id)
);
