ALTER TABLE ydir.organization_services
    ADD COLUMN ready_at TIMESTAMP WITH TIME ZONE;

UPDATE ydir.organization_services SET ready_at=first_action.timestamp
FROM (
    SELECT org_id, object->>'id' as id, min(timestamp) as timestamp FROM actions
    WHERE object_type='service' and name='service_ready'
    GROUP BY org_id, object->>'id'
) as first_action
WHERE ydir.organization_services.org_id=first_action.org_id and ydir.organization_services.id=first_action.id::bigint;

UPDATE ydir.organization_services SET ready_at=now() WHERE ydir.organization_services.ready_at IS NULL AND ydir.organization_services.ready=true;