CREATE INDEX IF NOT EXISTS organizations_subscription_plan_idx ON organizations (subscription_plan);

CREATE TABLE ydir.organizations_billing_consumed_info (
    org_id BIGSERIAL,
    total_users_count INTEGER NOT NULL,
    for_date DATE NOT NULL DEFAULT CURRENT_DATE,
    saved_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
    PRIMARY KEY (org_id, for_date),

    CONSTRAINT fk_organizations_billing_consumed_info_org_id
        FOREIGN KEY (org_id) REFERENCES ydir.organizations (id)
);
