/* pgmigrate-encoding: utf-8 */

ALTER TABLE ydir.departments ADD COLUMN members_count BIGINT NOT NULL DEFAULT 0;


CREATE OR REPLACE FUNCTION update_sub_members_count() RETURNS TRIGGER AS $$
BEGIN
    -- Если сработал новый код и в UPDATE
    -- изменили поле members_count,
    -- то проапдейтим и sub_members_count
    IF NEW.members_count != OLD.members_count THEN
      NEW.sub_members_count = NEW.members_count;
    END IF;
    
    -- Если сработал старый код и в UPDATE
    -- изменили поле sub_members_count,
    -- то проапдейтим и members_count
    IF NEW.sub_members_count != OLD.sub_members_count THEN
      NEW.members_count = NEW.sub_members_count;
    END IF;

    RETURN NEW;
END;
$$ LANGUAGE plpgsql;


CREATE TRIGGER update_sub_members_count
       BEFORE UPDATE ON ydir.departments
       FOR EACH ROW
       EXECUTE PROCEDURE update_sub_members_count();
