CREATE TABLE services (
    id BIGSERIAL NOT NULL,
    client_id TEXT,
    slug text NOT NULL,
    name text,
    robot_required BOOLEAN NOT NULL DEFAULT FALSE,
    tvm_client_id BIGINT,
    scopes TEXT[] NOT NULL DEFAULT '{}',
    out_of_the_box BOOLEAN NOT NULL DEFAULT False,
    ready_default  BOOLEAN NOT NULL DEFAULT True,
	priority INTEGER NOT NULL DEFAULT 1,
	data_by_tld JSONB NOT NULL DEFAULT JSONB('{}'),
    data_by_language JSONB NOT NULL DEFAULT JSONB('{}'),
    show_in_header BOOLEAN NOT NULL DEFAULT False,
    in_new_tab BOOLEAN NOT NULL DEFAULT False,
    robot_name JSONB,
	internal BOOLEAN NOT NULL DEFAULT FALSE,

    CONSTRAINT pk_services PRIMARY KEY (id)
);

CREATE UNIQUE INDEX uk_services_slug ON services (slug);
CREATE UNIQUE INDEX uk_services_client_id ON services (client_id);
