ALTER TABLE ydir.organization_services
    ADD UNIQUE (org_id, service_id);

CREATE TABLE ydir.user_service_licenses (
    org_id BIGINT NOT NULL,
    user_id BIGINT NOT NULL,
    service_id BIGINT NOT NULL,

    CONSTRAINT pk_user_service_licenses PRIMARY KEY (org_id, user_id, service_id),
    CONSTRAINT fk_user_service_licenses_user_id
        FOREIGN KEY (user_id) REFERENCES users (id)
        ON DELETE CASCADE,
    CONSTRAINT fk_user_service_licenses_org_id_resource_id
        FOREIGN KEY (org_id, service_id) REFERENCES organization_services (org_id, service_id)
        ON DELETE CASCADE
);