CREATE OR REPLACE FUNCTION make_user_name_tsvector (value text) RETURNS tsvector AS $$
BEGIN
    RETURN (
        replace(replace(replace(lower(coalesce(value, '')), ':', ''), '\', '\\'), E'\'', '')::tsvector
    );
END
$$
LANGUAGE plpgsql
IMMUTABLE;


CREATE OR REPLACE FUNCTION make_user_search_ts_vector (name JSONB, nickname TEXT) RETURNS tsvector AS $$
BEGIN
    RETURN (
        make_user_name_tsvector(name #>> '{{first, ru}}') ||
        make_user_name_tsvector(name #>> '{{last, ru}}') ||
        lower(nickname)::tsvector
    );
END
$$
LANGUAGE plpgsql
IMMUTABLE;


CREATE INDEX IF NOT EXISTS i_users_search2_idx
          ON ydir.users
       USING gin(
         make_user_search_ts_vector(
           users.name,
           users.nickname));
