CREATE TABLE ydir.organization_promocodes (
    org_id INTEGER NOT NULL,
    promocode_id VARCHAR(255) NOT NULL,
    expires_at TIMESTAMP NOT NULL,
    activated_at TIMESTAMP NOT NULL,
    active BOOLEAN,
    PRIMARY KEY (org_id, promocode_id)
);

-- only one active promocode per organization
CREATE INDEX IF NOT EXISTS organization_promocodes_unique_active_for_organization_idx ON organization_promocodes (org_id) WHERE active = TRUE;

CREATE INDEX IF NOT EXISTS organization_promocodes_org_id_idx ON organization_promocodes (org_id);
CREATE INDEX IF NOT EXISTS organization_promocodes_org_id_active_idx ON organization_promocodes (org_id, active);


ALTER TABLE organizations_billing_consumed_info
    ADD COLUMN promocode_id VARCHAR(255) DEFAULT NULL;
