CREATE TABLE ydir.requested_user_service_licenses (
    id BIGSERIAL NOT NULL,
    org_id BIGINT NOT NULL,
    user_id BIGINT NOT NULL,
    service_slug TEXT NOT NULL,

    CONSTRAINT pk_requested_user_service_licenses PRIMARY KEY (id),
    UNIQUE (org_id, user_id, service_slug),
    CONSTRAINT fk_requested_user_service_licenses_user_id
        FOREIGN KEY (user_id) REFERENCES users (id)
        ON DELETE CASCADE,
    CONSTRAINT fk_requested_user_service_licenses_org_id
        FOREIGN KEY (org_id) REFERENCES organizations (id)
        ON DELETE CASCADE,
    CONSTRAINT fk_requested_user_service_licenses_service_slug
        FOREIGN KEY (service_slug) REFERENCES services (slug)
        ON DELETE CASCADE
);