CREATE TABLE ydir.callback_events (
    id BIGSERIAL NOT NULL PRIMARY KEY,
    callback VARCHAR(255) NOT NULL,
    settings JSONB NOT NULL DEFAULT JSONB('{}'),
    event_id BIGINT NOT NULL,

    UNIQUE (event_id, callback),
    CONSTRAINT fk_callback_tasks_event_id
        FOREIGN KEY (event_id) REFERENCES events (id)
        ON DELETE CASCADE
);

CREATE INDEX IF NOT EXISTS callback_tasks_callback_idx ON callback_events(callback);


CREATE TABLE ydir.last_processed_event_id (
  id INT PRIMARY KEY NOT NULL DEFAULT(1) CHECK (id = 1),
  last_processed_event_id integer DEFAULT 0
);

INSERT INTO last_processed_event_id(last_processed_event_id)
    SELECT max(id) FROM events;


ALTER TABLE events ADD COLUMN notify_at TIMESTAMP WITH TIME ZONE NULL;
UPDATE events SET notify_at = now();
ALTER TABLE events ALTER COLUMN notify_at SET DEFAULT now();
ALTER TABLE events ALTER COLUMN notify_at SET NOT NULL;