CREATE TABLE ydir.organizations_analytics_info (
    id BIGINT NOT NULL,
    registration_date TEXT NOT NULL,
    source TEXT NOT NULL,
    subscription_plan TEXT NOT NULL,
    language TEXT,
    tld TEXT,
    country TEXT,
    balance TEXT,
    first_debt_act_date TEXT,
    services TEXT[],
    for_date TEXT NOT NULL DEFAULT to_char(CURRENT_DATE, 'YYYY-MM-DD'),

    PRIMARY KEY (id, for_date)
);

CREATE TABLE ydir.users_analytics_info (
    uid BIGINT NOT NULL,
    org_id BIGINT NOT NULL,
    created TEXT NOT NULL,
    for_date TEXT NOT NULL DEFAULT to_char(CURRENT_DATE, 'YYYY-MM-DD'),

    PRIMARY KEY (uid, for_date)
);

CREATE TABLE ydir.domains_analytics_info (
    name TEXT NOT NULL,
    org_id BIGINT NOT NULL,
    for_date TEXT NOT NULL DEFAULT to_char(CURRENT_DATE, 'YYYY-MM-DD'),

    PRIMARY KEY (name, org_id, for_date)
);

CREATE TABLE ydir.organizations_services_analytics_info (
    slug TEXT NOT NULL,
    org_id BIGINT NOT NULL,
    trial_expires TEXT,
    ready_at TEXT NOT NULL,
    enabled BOOLEAN NOT NULL,
    disable_reason TEXT,
    enabled_at TEXT,
    disabled_at TEXT,
    for_date TEXT NOT NULL DEFAULT to_char(CURRENT_DATE, 'YYYY-MM-DD'),

    PRIMARY KEY (slug, org_id, for_date)
);
