DROP TYPE IF EXISTS user_type;

CREATE TYPE user_type AS ENUM (
  'user', 'robot', 'yamb_bot'
);

ALTER TABLE users
  ADD COLUMN user_type user_type;

UPDATE users
SET user_type = (
  CASE
  WHEN id IN (
    SELECT uid
    FROM robot_services
  )
    THEN
      'robot' :: user_type
  ELSE
    'user' :: user_type
  END
);

ALTER TABLE users
  ALTER COLUMN user_type SET NOT NULL;

ALTER TABLE users
  ALTER COLUMN user_type SET DEFAULT 'user'::user_type;