DROP TYPE IF EXISTS trial_status_type;

CREATE TYPE trial_status_type AS ENUM (
  'inapplicable',
  'in_progress',
  'expired'
);

ALTER TABLE organization_services
  ADD COLUMN trial_status trial_status_type DEFAULT 'inapplicable';

UPDATE organization_services
SET trial_status = (
  CASE
  WHEN trial_expires::date < NOW() THEN 'expired'::trial_status_type
  WHEN resource_id IS NOT NULL and (trial_expires IS NULL OR trial_expires::date >= NOW()) THEN 'in_progress'::trial_status_type
  WHEN resource_id IS NULL THEN 'inapplicable'::trial_status_type
  END
);

ALTER TABLE organization_services
  ALTER COLUMN trial_status SET NOT NULL;