ALTER TABLE ydir.users
  ADD COLUMN first_name TEXT,
  ADD COLUMN last_name TEXT,
  ADD COLUMN middle_name TEXT,
  ADD COLUMN position_plain TEXT,
  ADD COLUMN about_plain TEXT;
CREATE INDEX i_users_last_first_middle ON ydir.users (last_name, first_name, middle_name);

ALTER TABLE ydir.users
  ALTER COLUMN first_name SET DEFAULT '',
  ALTER COLUMN last_name SET DEFAULT '',
  ALTER COLUMN middle_name SET DEFAULT '';

UPDATE ydir.users SET
first_name = COALESCE (name->'first'->>'ru', name->'first'->>'en'),
last_name = COALESCE (name->'last'->>'ru', name->'last'->>'en'),
middle_name = COALESCE (name->'middle'->>'ru', name->'middle'->>'en'),
position_plain = COALESCE (position->>'ru', position->>'en'),
about_plain = COALESCE (about->>'ru', about->>'en');

ALTER TABLE ydir.users
    ALTER COLUMN first_name SET NOT NULL;


ALTER TABLE ydir.groups
  ADD COLUMN name_plain TEXT,
  ADD COLUMN description_plain TEXT;
CREATE INDEX i_groups_name_plain ON ydir.groups (name_plain);

ALTER TABLE ydir.groups
  ALTER COLUMN name_plain SET DEFAULT '';

UPDATE ydir.groups SET
name_plain = COALESCE (name->>'ru', name->>'en'),
description_plain = COALESCE (description->>'ru', description->>'en');

ALTER TABLE ydir.groups
    ALTER COLUMN name_plain SET NOT NULL;


ALTER TABLE ydir.departments
  ADD COLUMN name_plain TEXT,
  ADD COLUMN description_plain TEXT;
CREATE INDEX i_departments_name_plain ON ydir.departments (name_plain);

ALTER TABLE ydir.departments
  ALTER COLUMN name_plain SET DEFAULT '';

UPDATE ydir.departments SET
name_plain = COALESCE (name->>'ru', name->>'en'),
description_plain = COALESCE (description->>'ru', description->>'en');

ALTER TABLE ydir.departments
    ALTER COLUMN name_plain SET NOT NULL;