DROP TYPE IF EXISTS organization_type;

CREATE TYPE organization_type AS ENUM (
  'common',
  'education',
  'yandex_project',
  'test',
  'portal',
  'cloud',
  'partner_organization'
);

ALTER TABLE organizations
  ADD COLUMN organization_type organization_type;

UPDATE organizations SET organization_type = 'common'::organization_type;

ALTER TABLE organizations
  ALTER COLUMN organization_type SET DEFAULT 'common'::organization_type;

ALTER TABLE organizations
  ALTER COLUMN organization_type SET NOT NULL;
